<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class Categories extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'categories';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute() {
      
                    if ($this->image_id != '')
                        return url($this->image_id);
                return '';
    }
    function langs(){
        return $this->hasMany(CategoriesLanguages::class,'category_id');
    }
    function childs(){
        return $this->hasMany(Self::class,'parent_id');
    }
    function parent(){
        return $this->belongsTo(Self::class,'parent_id');
    }

  
}
