<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use traits\TraitLanguage;
use Elsayednofal\Imagemanager\Http\Controllers\Facades\ImageManager;

class Banners extends BaseModel {

    use traits\TraitLanguage;

    protected $table = 'banners';
    public $rules = [
        'image_id' => 'required'
    ];
    protected $guarded = ['id'];

    function getImageAttribute() {
       
                    if ($this->image_id != '')
                        return url($this->image_id);
                return '';
    }
    function getThumbAttribute() {
       
                    if ($this->image_id != '')
                    {
                        $image= str_replace('uploads', 'uplouds/thumbs', $this->image_id);
                        if(file_exists(url($image)))
                            return url($image);
                        else return url($this->image_id);
                    }
                return '';
    }
    function langs(){
        return $this->hasMany(BannersLanguages::class,'banner_id');
    }
    function lang(){
        return $this->hasOne(BannersLanguages::class,'banner_id');
    }

  
}
