<?php

namespace App\Http\Middleware;

use Closure;

class apiDelegate {

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next) {
        if ($request->token == null) {


            $arr = ['status' => 403, 'message' => 'Login First'];
            return response()->json($arr);
        } else {
            $usertoken = \App\Models\DelegatesTokens::where('token', $request->token)->first();

            if (!is_object($usertoken)) {
                  $arr = ['status' => 402, 'message' => 'Token Not Found'];
                  return response()->json($arr);
            }
            $user = \App\Models\Delegates::find($usertoken->delegate_id);
            if(is_object($user)&&$user->accept==0){
                $arr = ['status' => 402, 'message' => 'User Not Accepted Yet'];
                return response()->json($arr);
            }elseif(is_object($user)&&$user->accept==2){
                $arr = ['status' => 402, 'message' => 'User is reused '];
                return response()->json($arr);
            }elseif(is_object($user)&&$user->active==0){
                $arr = ['status' => 402, 'message' => 'User is forbidden '];
                return response()->json($arr);
            }
            if (!is_object($user)) {

                $arr = ['status' => 402, 'message' => 'User Not Found'];
                return response()->json($arr);
            }
            }
        return $next($request);
    }

}
