<?php

namespace App\Http\Middleware;

use Closure;

class apiAuth {

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next) {
        if ($request->token == null) {


            $arr = ['status' => 403, 'message' => 'Login First'];
            return response()->json($arr);
        } else {
            $usertoken = \App\Models\CustomersTokens::where('token', $request->token)->first();

            if (!is_object($usertoken)) {
                  $arr = ['status' => 402, 'message' => 'Token Not Found'];
                  return response()->json($arr);
            }
            $user = \App\Models\Customers::find($usertoken->customer_id);
            if (!is_object($user)) {

                $arr = ['status' => 402, 'message' => 'User Not Found'];
                return response()->json($arr);
            }
            }
        return $next($request);
    }

}
