<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Cities;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;

class Subdomain {

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next) {

        dd($request->user);
      
        if ($request->language_symbol != '') {

            $symbole = $request->language_symbol;
        } else if (Session::has('language')) {
            $symbole = session('language');
            $languages = \Cache::rememberForever('languages_' . $symbole, function()use($symbole) {
                        return \App\Models\Languages::where('symbol', $symbole)->first();
                    });
            Session::put('language_id', $languages->id);
            app()->setLocale($symbole);
            return redirect('./' . session('language') . '/' . $request->path())->with('x', 85);
        } else {
            $symbole = 'ar';

            Session::put('language', $symbole);
            $languages = \Cache::rememberForever('languages_' . $symbole, function()use($symbole) {
                        return \App\Models\Languages::where('symbol', $symbole)->first();
                    });
            Session::put('language_id', $languages->id);
            app()->setLocale($symbole);
            return redirect('./' . $symbole);
        }


        $languages = \Cache::rememberForever('languages_' . $symbole, function()use($symbole) {
                    return \App\Models\Languages::where('symbol', $symbole)->first();
                });
        if (!is_object($languages)) {
            app()->setLocale($symbole);
            return redirect('./ar/' . $request->path())->with('x', 85);
        }
        Session::put('language_id', $languages->id);

        Session::put('language', $languages->symbol);
        app()->setLocale($symbole);
        return $next($request);
    }

}
