<?php

namespace App\Http\Middleware;

use Closure;
use MediaSci\CmsBackendAuth\Models\CmsBackendPage;
use MediaSci\CmsBackendAuth\Models\CmsBackendRoleAction;

class CmsBackendRoles {

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next) {
//        $this->roles();
        $action = $this->getAction(); 
      
           if($this->checkAction($action) == false)
        {
            return redirect(config('cms-backend-auth.prefix').'/lockedscreen');
        }

        return $next($request);
    }

    function getAction() {
        $action = app('request')->route()->getAction();
        $controller = class_basename($action['controller']);
        $route = explode("@", $controller);
        $controller = strtolower(str_replace('Controller', '', $route[0]));
        $action = strtolower(str_replace(['any', 'post', 'get'], '', $route[1]));
        return['controller' => $controller, 'action' => $action];
    }

    function checkAction($action) {
        if (\Session('backendUser')->role->is_super == 1)
            return TRUE;
        $pageAction = \App\Models\CmsModels::where('name', $action['controller'])->first();
        if (!$pageAction)
            return false;
        $actionRole = CmsBackendRoleAction::where('role_id', \Session('backendUser')->role_id)->where('action_id', $pageAction->id)->count();
        if ($actionRole == 0)
            return false;

        return true;
    }
        private function roles()
    {
        $rule =\Session('backendUser')->role ;
//        dd($rule);
//        if($rule->is_super == false)
//        {
            $role_actions = CmsBackendRoleAction::where('role_id', $rule->id)
                            ->join('cms_backend_pages', 'cms_backend_pages.id', '=', 'cms_backend_role_actions.action_id')
                            ->select('action','module')->get();
//        }
//        else
//        {
//            $role_actions = [];
//        }
        $data = [];
   
        foreach($role_actions as $row)
        {
            $data[] = $row->module.'.'.$row->action;
        }
       
        view()->share('role_actions', $data);
    }

}
