<?php

namespace App\Http\Middleware;

use Closure;
use App\Models\Cities;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Session;

class ApiLanguage {

    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next) {

//        dd([$request->language_symbol,Session::has('language')]);
        if ($request->has('currency_symbol')&&($request->currency_symbol=='SAR')||$request->currency_symbol=='USD') {
            $currency = \App\Models\Currancy::where('currancy_symbol', 'SAR')->first();
            Session::put('currency', $currency);
        }
        if ($request->has('language_symbol')&&($request->language_symbol=='ar')||$request->language_symbol=='en') {
            $symbole = $request->language_symbol;
             $languages = \Cache::rememberForever('languages_' . $symbole, function()use($symbole) {
                        return \App\Models\Languages::where('symbol', $symbole)->first();
                    });
                    
            Session::put('language_id', $languages->id);
        } else {
            $symbole = 'en';
           $languages = \Cache::rememberForever('languages_' . $symbole, function()use($symbole) {
                        return \App\Models\Languages::where('symbol', $symbole)->first();
                    });
            Session::put('language_id', $languages->id);
           
        }
      Session::put('language', $symbole);

        app()->setLocale($symbole);
    
        return $next($request);
    }

}
