<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

class RequestsController extends Controller {

    function order(Request $request) {
        if ($request->order['type'] == 2) {
            $request->replace($request->except('order.product_id'));
        }
        $rules = ['order.*' => 'required'];

        $validator = \Validator::make($request->all(), $rules);

        if ($validator->fails()) {

            session()->put('errors', $validator->errors()->all());
            return redirect()->back();
        }
        $order = new \App\Models\Orders();
        $order->fill($request->order);
        $order->save();
        $order = $order->toArray();
        $message = '<table>';
        foreach ($order as $key => $value) {
            $message .= '<tr><th>' . strtoupper($key) . '</th><td>' . $value . '</td></tr>';
        }
        $message .= '</table>';
        if ($request->order['type'] == 2) {
            $title = 'New User Sent Conatct us Message';
            $email = \App\Models\CmsSetting::where('key', 'contact_mail')->first()->value;
        } else {
            $email = \App\Models\CmsSetting::where('key', 'order_mail')->first()->value;
            $title = 'New User Sent product order Message';
        }
        $this->sentmail($email, $title, $message);
        session()->put('suceess', 'success');
        return redirect()->back();
    }

    function subscribe(Request $request) {
        $rules = ['email' => 'required|unique:subscribers,email'];
        $validator = \Validator::make($request->all(), $rules);

        if ($validator->fails()) {

            session()->put('sub_errors', $validator->errors()->all());
            return redirect()->back();
        }
        $sub = new \App\Models\Subscribers();
        $sub->email = $request->email;
        $sub->save();
        session()->put('sub_success', 'success');
        return redirect()->back();
    }

    function book(Request $request) {
        $rules = ['booking' => 'required',
            'booking.*' => 'required'
        ];
        $validator = \Validator::make($request->all(), $rules);

        if ($validator->fails()) {

            session()->put('errors', $validator->errors()->all());
            return redirect()->back();
        }
        $booking = new \App\Models\Booking();
        $booking->fill($request->booking);
        $booking->save();
        $booking = $booking->toArray();
        $message = '<table>';
        foreach ($booking as $key => $value) {
            $message .= '<tr><th>' . strtoupper($key) . '</th><td>' . $value . '</td></tr>';
        }
        $message .= '</table>';
        $title = 'new USer Bookend event';
        $email = \App\Models\CmsSetting::where('key', 'event_mail')->first()->value;
        $this->sentmail($email, $title, $message);
        session()->put('suceess', 'success');
        return redirect()->back();
    }

    function submit(Request $request) {
        $rules = ['cv' => 'required',
            'cv.*' => 'required',
            'file' => 'required|mimes:doc,docx,pdf'];
        $validator = \Validator::make($request->all(), $rules);

        if ($validator->fails()) {

            session()->put('errors', $validator->errors()->all());
            return redirect()->back();
        }
        $career = new \App\Models\Career();
        $career->fill($request->cv);
        $career->cv = $this->uploadfile($request->file('file'));
        $career->save();
        $career = $career->toArray();
        $message = '<table>';
        foreach ($career as $key => $value) {
            $message .= '<tr><th>' . strtoupper($key) . '</th><td>' . $value . '</td></tr>';
        }
        $message .= '</table>';
        $title = 'new USer Bookend event';
        $email = \App\Models\CmsSetting::where('key', 'career_mail')->first()->value;
        $this->sentmail($email, $title, $message);
        session()->put('suceess', 'success');
        return redirect()->back();
    }

    private function uploadfile($file) {
        $path = 'uploads/cvs';
        if (!file_exists($path)) {
            mkdir($path, 0775);
        }
        $datepath = date('m-Y', strtotime(\Carbon\Carbon::now()));
        if (!file_exists($path . '/' . $datepath)) {
            mkdir($path . '/' . $datepath, 0775);
        }
        $newdir = $path . '/' . $datepath;
        $exten = $file->getClientOriginalExtension();
        $filename = $this->generateRandom($length = 15);
        $filename = $filename . '.' . $exten;
        $file->move($newdir, $filename);
        return $newdir . '/' . $filename;
    }

    function generateRandom($length = 11) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = time();
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        return $randomString;
    }

}
