<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Banners;
use App\Models\BannersLanguages;
use App\Models\IndexSections;
use App\Models\MainCategories;
use App\Models\News;
use App\Models\Products;
use App\Models\SecondaryCategories;
use App\Models\Services;
use App\Models\SuccessStories;
use App\Models\Testimonials;
use Illuminate\Http\Request;

class ProductsController extends Controller {
    function index(){
 
        $data['categories']=MainCategories::latest('id')->get();
    
        return view('front.shop.index',$data);
    }
    function subCategories(Request $request)
    {
        $id = $request->route()->parameters()['id'];
        $data['main_category']=MainCategories::find($id);
        $data['categories']=SecondaryCategories::where('main_category_id',$id)->get();

        return view('front.shop.sub_categories',$data);
    }
    function products(Request $request){
        $id = $request->route()->parameters()['id'];
        $data['category']=SecondaryCategories::find($id);
        $data['products']=Products::where('category_id',$id)->paginate(9);
        return view('front.shop.products',$data);
    }
    function show(Request $request,$name='')
    {
        $id = $request->route()->parameters()['id'];
        $data['products']=Products::latest('id')->where('id','!=',$id)->limit(3)->get();
        $data['product']=$page=Products::find($id);
        $page->views=$page->views+1;
        $page->save();
        return view('front.shop.show',$data);

    }
}