<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Banners;
use App\Models\BannersLanguages;
use App\Models\Events;
use App\Models\IndexSections;
use App\Models\News;
use App\Models\Services;
use App\Models\SuccessStories;
use App\Models\Testimonials;
use Illuminate\Http\Request;

class NewsController extends Controller {
    function index(){
 
        $data['news']=News::latest('id')->paginate(6);
       
        $data['services']=Services::latest('id')->get();
        $data['recent_news']=News::latest('id')->limit(5)->get();
    
        return view('front.blogs.index',$data);
    }
    function show(Request $request,$name='')
    {
        $id = $request->route()->parameters()['id'];
        $data['news']=$page=News::findOrFail($id);
        $page->views=$page->views+1;
        $page->save();
        $data['services']=Services::latest('id')->get();
        $data['recent_news']=News::latest('id')->limit(5)->get();

        return view('front.blogs.show',$data);

    }
}