<?php

namespace App\Http\Controllers\Front;

use App\Http\Controllers\Controller;
use App\Models\Banners;
use App\Models\BannersLanguages;
use App\Models\Career;
use App\Models\Collaborators;
use App\Models\Contacts;
use App\Models\IndexSections;
use App\Models\Languages;
use App\Models\MainCategories;
use App\Models\News;
use App\Models\Partners;
use App\Models\Products;
use App\Models\Services;
use App\Models\StartedSections;
use App\Models\StaticPages;
use App\Models\Statistics;
use App\Models\Subscribers;
use App\Models\SuccessStories;
use App\Models\Testimonials;
use Illuminate\Http\Request;

class HomeController extends Controller
{
    function index()
    {


        $data['banners'] = Banners::all();
        $data['about'] = IndexSections::first();
        $data['trust'] = IndexSections::find(7);
        $data['offers'] = SuccessStories::where('in_home',1)->latest('id')->get();
        $data['categories']=MainCategories::where('in_home',1)->get();
        $data['products']=Products::where('in_home',1)->latest('id')->get();
        $data['collaborators'] = Collaborators::all();

        $data['services'] = Services::where('in_home',1)->latest('id')->get();
        return view('front.pages.index', $data);
    }
    function about(){
        $data['about']=StaticPages::where('slug','about-us')->first();
        $data['collaborators'] = Collaborators::all();

        return view('front.pages.about', $data);

    }
    function contact(){
        return view('front.pages.contact');
    }
    function careers(){
        $data['career']=$page=StaticPages::where('slug','careers')->first();
        
        $page->views=$page->views+1;
        $page->save();
        return view('front.pages.careers', $data);

    }
    function terms(){
        $data['terms']=$page=StaticPages::where('slug','terms')->first();
        $page->views=$page->views+1;
        $page->save();
        return view('front.pages.terms', $data);

    }
    function privacy(){
        $data['privacy']=$page=StaticPages::where('slug','privacy')->first();
        $page->views=$page->views+1;
        $page->save();
        return view('front.pages.privacy', $data);

    }
    function store(Request $request){
        $request->validate([
            'name'=>'required',
            // 'email'=>'required|email',
            'phone'=>'required',
            // 'subject'=>'required',
            'message'=>'required',
        ]);
        
        $contact=Contacts::create([
            'name'=>$request->name,
            'email'=>$request->email,
            'phone'=>$request->phone,
            'subject'=>$request->subject,
            'message'=>$request->message,
        ]);
//        if($request->service==''){
            $this->sendContactEmail($contact);
//        }elseif($request->service=='get-started'){
//            $this->sendStartedEmail($contact);
//
//        }else{
//
//            $this->sendServiceEmail($contact);
//        }
        session()->put('contact_success',1);
        return redirect()->back();

    }

    function Subscribe(Request $request){
       $subscriber=new Subscribers();
       $subscriber->email=$request->email;
       $subscriber->save();
       
        session()->put('subscribe_success',1);
        return redirect()->back();

    }
    function submitCv(Request $request){
        $request->validate([
            'name'=>'required',
            'email'=>'required|email',
            'phone'=>'required',
            'years'=>'required|numeric',
            'age'=>'required|numeric',
            'job_title'=>'required',
            'cv'=>'required'
        ]); 
        $career=new Career();
        $career->name=$request->name;
        $career->email=$request->email;
        $career->phone=$request->phone;
        $career->years=$request->years;
        $career->age=$request->age;
        $career->job_title=$request->job_title;
        $career->cv=$this->uploadfile($request->file('cv'));
        $career->save();
        $this->sendCareerEmail($career);
        session()->put('career_success',1);
        return redirect()->back();
    }
    private function uploadfile($file) {
        $path = 'uploads/cvs';
        if (!file_exists($path)) {
            mkdir($path, 0775);
        }
        $datepath = date('m-Y', strtotime(\Carbon\Carbon::now()));
        if (!file_exists($path . '/' . $datepath)) {
            mkdir($path . '/' . $datepath, 0775);
        }
        $newdir = $path . '/' . $datepath;
        $exten = $file->getClientOriginalExtension();
        $filename = $this->generateRandom($length = 15);
        $filename = $filename . '.' . $exten;
        $file->move($newdir, $filename);
        return $newdir . '/' . $filename;
    }

    function generateRandom($length = 11) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = time();
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        return $randomString;
    }
    function getStarted(){
        $data['page']=$page=StaticPages::where('slug','get_started')->first();
        $page->views=$page->views+1;
        $page->save();
        $data['collaborators'] = Collaborators::all();

        $data['section']=StartedSections::first();
        $data['sections']=StartedSections::where('id','!=',1)->get();
        return view('front.pages.started',$data);
    }
    function clients(){
        return view('front.pages.clients');
    }
    function partners(){
        return view('front.pages.partners');
    }
    function changeLanguage(Request $request,$id)
    {
      $previous_symbol=session('language');
        session()->put('language', Languages::find($id)->symbol);
        $previous=str_replace($previous_symbol,Languages::find($id)->symbol,url()->previous());
        session()->put('language_obj', Languages::find($id));
        session()->put('language_id', $id);
        return redirect($previous);
    }
}
