<?php

namespace App\Http\Controllers;

use App\Models\Shippings;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use App\Models\Cart;
use App\Models\CmsSetting;

class Controller extends BaseController {

    use AuthorizesRequests,
        DispatchesJobs,
        ValidatesRequests;
       function sendAdminMail($order) {
        $data['order'] = $order;
        $data['shipping'] = Shippings::first();
        $setting = \App\Models\CmsSetting::getAllSettings();

        $message = view('front.emails.neworder', $data)->render();
        $this->sentmail($setting['admin_email'], 'New Success Order', $message);
        return true;
    }

    function sendUserMail($order) {
        $data['order'] = $order;
        $data['shipping'] = Shippings::first();

        $message = view('front.emails.order_success', $data)->render();
        $this->sentmail($order->email, 'الطلب ناجح، برجاء إتمام الدفع للتفعيل', $message);
        return true;
    }

    function sentmail($to, $subject, $message) {

        $headers = 'MIME-Version: 1.0' . "\r\n";
        $headers .= 'Content-type: text/html; charset=UTF-8' . "\r\n";
        $headers .= 'From: Website@fantasticeg.com' . "\r\n" .
                'X-Mailer: PHP/' . phpversion();

         mail($to, $subject, $message,$headers);
    }
    function sendContactEmail($contact){
        $title='New user send Message';
        $message=$this->handleMessage($contact);
        $setting=CmsSetting::where('key','contacts_notification_email')->first();
        if(is_object($setting))
        $this->sentmail($setting->value,$title,$message);
    }
    function sendStartedEmail($contact){
        $title='New user send Started Message';
        $message=$this->handleMessage($contact);
        $setting=CmsSetting::where('key','started_notification_email')->first();
        if(is_object($setting))
        $this->sentmail($setting->value,$title,$message);


    }
    function sendServiceEmail($contact){
        $title='New user request service ';
        $message=$this->handleMessage($contact);
        $setting=CmsSetting::where('key','services_notification_email')->first();
        if(is_object($setting))
        $this->sentmail($setting->value,$title,$message);

    }
    function sendCareerEmail($contact){
        $title='New user send C.v ';
        $message=$this->handleCareer($contact);
        $setting=CmsSetting::where('key','careers_notification_email')->first();
        if(is_object($setting))
        $this->sentmail($setting->value,$title,$message);

    }
    function handleMessage($contact){
        $message="<table>";
        $message.="<tr><th>Name</th><td>".$contact->name."</tr>";
        $message.="<tr><th>Email</th><td>".$contact->email."</tr>";
        $message.="<tr><th>Phone</th><td>".$contact->phone."</tr>";
        $message.="<tr><th>Subject</th><td>".$contact->subject."</tr>";
        $message.="<tr><th>message</th><td>".$contact->message."</tr>";
        $message.="<tr><th>Page</th><td><a href='".url()->previous()."'>go</a></tr>";
       
        $message.="</table>";
        return $message;
    }
    function handleCareer($contact){
        $message="<table>";
        $message.="<tr><th>Name</th><td>".$contact->name."</tr>";
        $message.="<tr><th>Email</th><td>".$contact->email."</tr>";
        $message.="<tr><th>Phone</th><td>".$contact->phone."</tr>";
        $message.="<tr><th>Years of experience</th><td>".$contact->years."</tr>";
        $message.="<tr><th>Age</th><td>".$contact->age."</tr>";
        $message.="<tr><th>Job Title</th><td>".$contact->job_title."</tr>";
        $message.="<tr><th>C.V</th><td><a href='".url($contact->cv)."' class='btn' >download</a></tr>";
       
        $message.="</table>";
        return $message;
    }

}
