<?php
namespace App\Http\Controllers\Backend\export;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use App\Models\Contacts;
class ExportOrder implements FromCollection
{
    function collection() {
         $kits = \App\Models\Orders::where('type',1)->orderBy('id', 'desc')->get();
        $kitsData = [];
        $kitsData[0] = ['name' => 'Name', 'address' => 'Address', 'email'=>'Email','phone' => 'Phone', 'company' => 'Company','product'=>'Product','message'=>'Message','date'=>'Date '];
        foreach ($kits as $key => $kit) {
            $kitsData[$key + 1]['name'] = $kit->name;
            $kitsData[$key + 1]['address'] = $kit->country.$kit->town;
            $kitsData[$key + 1]['email'] = $kit->email;
            $kitsData[$key + 1]['phone'] = $kit->phone;
           
            $kitsData[$key + 1]['company'] = $kit->company;
           
            $kitsData[$key + 1]['product'] = $kit->product;
           
            $kitsData[$key + 1]['message'] = $kit->message;
            $kitsData[$key + 1]['date'] = date('d / m/Y',strtotime($kit->created_at));
           
        }
        return new \Illuminate\Database\Eloquent\Collection($kitsData);
    }
}