<?php
namespace App\Http\Controllers\Backend\export;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use App\Models\Contacts;
class ExportContacts implements FromCollection
{
    function collection() {
        
       $kits = \App\Models\Contacts::orderBy('id', 'desc')->get();
        $kitsData = [];
        $kitsData[0] = ['name' => 'Name', 'email'=>'Email' ,'phone' => 'Phone', 'subject' => 'Subject','service'=>'Service','message'=>'Message','date'=>'Date '];
        foreach ($kits as $key => $kit) {
            $kitsData[$key + 1]['name'] = $kit->name;
            $kitsData[$key + 1]['email'] = $kit->email;
            $kitsData[$key + 1]['phone'] = $kit->phone;
           
            $kitsData[$key + 1]['subject'] = $kit->subject;
           
            $kitsData[$key + 1]['message'] = $kit->message;
            $kitsData[$key + 1]['service'] = $kit->service??'contact us';
            $kitsData[$key + 1]['date'] = date('d / m/Y',strtotime($kit->created_at));
           
        }
        return new \Illuminate\Database\Eloquent\Collection($kitsData);
    }
}