<?php
namespace App\Http\Controllers\Backend\export;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use App\Models\User;
class ExportCareer implements FromCollection
{
    function collection() {
        $kits = \App\Models\Career::orderBy('id', 'desc')->get();
        $kitsData = [];
        $kitsData[0] = ['name' => 'Name', 'years' => 'Years Of Experiece', 'phone' => 'Phone', 'email' => 'Email','job'=>'Job Title','age'=>'Age','cv'=>'C.V','date'=>'Date '];
        foreach ($kits as $key => $kit) {
            $kitsData[$key + 1]['name'] = $kit->name;
            $kitsData[$key + 1]['years'] = $kit->years;
            $kitsData[$key + 1]['phone'] = $kit->phone;
            $kitsData[$key + 1]['email'] = $kit->email;
           
            $kitsData[$key + 1]['job'] = $kit->job_title;
            $kitsData[$key + 1]['age'] = $kit->age;
            $kitsData[$key + 1]['cv'] = url($kit->cv);
           
          
            $kitsData[$key + 1]['date'] = date('d / m/Y',strtotime($kit->created_at));
           
        }
        return new \Illuminate\Database\Eloquent\Collection($kitsData);
    }
}