<?php
namespace App\Http\Controllers\Backend\export;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Concerns\FromCollection;
use App\Models\User;
class ExportBooking implements FromCollection
{
    function collection() {
        $kits = \App\Models\Booking::orderBy('id', 'desc')->get();
        $kitsData = [];
        $kitsData[0] = ['name' => 'Name',  'phone' => 'Phone', 'email' => 'Email','message'=>'Message','event'=>'Event','date'=>'Date '];
        foreach ($kits as $key => $kit) {
            $kitsData[$key + 1]['name'] = $kit->name;
            $kitsData[$key + 1]['phone'] = $kit->phone;
            $kitsData[$key + 1]['email'] = $kit->email;
           
            $kitsData[$key + 1]['message'] = $kit->message;
            $kitsData[$key + 1]['event'] = $kit->event;
          
           
          
            $kitsData[$key + 1]['date'] = date('d / m/Y',strtotime($kit->created_at));
           
        }
        return new \Illuminate\Database\Eloquent\Collection($kitsData);
    }
}