<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Translations;
use App\Models\TranslationsLanguages;

class TranslationsController extends Controller {

    function anyIndex() {
        $data['result'] = Translations::orderBy('id', 'desc')->where('active',1)->get();
        return view('backend.translations.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        if ($request->has('save')) {

            $return = $this->store($request, new Translations());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/translations');
            }
        }
        return view('backend.translations.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['translation'] = $translation = Translations::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();

        if ($request->has('save')) {
            $return = $this->store($request, $translation);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/translations');
            }
        }

        return view('backend.translations.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            
            
            if(!($object->exists))
             $rules['slug']='required|unique:translations,slug';   
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
              
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                return ['status' => false];
            }
            if(!($object->exists))
            $object->slug=$request->slug;
         

            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\TranslationsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->translation_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Translations::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['translation'] = $translation = Translations::findOrFail($id);
        $data['result'] = TranslationsLanguages::where('translation_id', $id)->where('language_id', '!=', $translation->language->language_id)->get();
        return view('backend.translations.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['translation'] = $translation = Translations::findOrFail($id);
        $ids = TranslationsLanguages::where('translation_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new TranslationsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/translations');
            }
        }
        return view('backend.translations.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['translationLanguage'] = $translationLanguage = TranslationsLanguages::findOrFail($id);
        $ids = TranslationsLanguages::where('translation_id', $translationLanguage->translation_id)
                        ->where('language_id', '!=', $translationLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($translationLanguage->translation_id, $request, $translationLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/translations/languages/' . $translationLanguage->translation_id);
            }
        }
        return view('backend.translations.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->translation_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = TranslationsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
