<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Testimonials;
use App\Models\TestimonialsLanguages;

class TestimonialsController extends Controller {

    function anyIndex() {
        $data['result'] = Testimonials::orderBy('id', 'desc')->get();
        return view('backend.testimonials.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        if ($request->has('save')) {

            $return = $this->store($request, new Testimonials());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/testimonials');
            }
        }
        return view('backend.testimonials.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['testimonial'] = $testimonial = Testimonials::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();


        if ($request->has('save')) {
            $return = $this->store($request, $testimonial);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/testimonials');
            }
        }

        return view('backend.testimonials.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
          
            /**
             * Object
             */
            $rules['image'] = 'required';
            
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['name_' . $lang->id] = 'required';
                $rules['university_' . $lang->id] = 'required';
                $rules['job_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
          

            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\TestimonialsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->testimonial_id = $object->id;
                $objectLanguage->name = $request->get('name_' . $lang->id);
                $objectLanguage->university = $request->get('university_' . $lang->id);
                $objectLanguage->job = $request->get('job_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
return ['status' => false];
        }
    }

    function anyDelete($id) {
        $object = Testimonials::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['testimonial'] = $testimonial = Testimonials::findOrFail($id);
        $data['result'] = TestimonialsLanguages::where('testimonial_id', $id)->where('language_id', '!=', $testimonial->language->language_id)->get();
        return view('backend.testimonials.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['testimonial'] = $testimonial = Testimonials::findOrFail($id);
        $ids = TestimonialsLanguages::where('testimonial_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new TestimonialsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/testimonials');
            }
        }
        return view('backend.testimonials.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['testimonialLanguage'] = $testimonialLanguage = TestimonialsLanguages::findOrFail($id);
        $ids = TestimonialsLanguages::where('testimonial_id', $testimonialLanguage->testimonial_id)
                        ->where('language_id', '!=', $testimonialLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($testimonialLanguage->testimonial_id, $request, $testimonialLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/testimonials/languages/' . $testimonialLanguage->testimonial_id);
            }
        }
        return view('backend.testimonials.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->testimonial_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = TestimonialsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
