<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\SuccessStories;
use App\Models\SuccessStoriesLanguages;

class SuccessStoriesController extends Controller {

    function anyIndex() {
        $data['result'] = SuccessStories::orderBy('id', 'desc')->get();
        return view('backend.success_stories.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
//        dd($request->all());
        if ($request->has('save')) {

            $return = $this->store($request, new SuccessStories());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/success_stories');
            }
        }
        return view('backend.success_stories.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['success_story'] = $success_story = SuccessStories::findOrFail($id);
        // if($success_story->id==3||$success_story->id==2||$id==4)
        // \abort(404);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();

// dd($data);

        if ($request->has('save')) {
            $return = $this->store($request, $success_story);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/success_stories');
            }
        }

        return view('backend.success_stories.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
              
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->in_home = $request->in_home;
            $object->image_id = $request->image;
            if($request->is_file_deleted==1)
                $object->discover_file='';
            if($request->hasFile('discover_file'))
                $object->discover_file=$this->uploadfile($request->file('discover_file'));


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\SuccessStoriesLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->success_story_id = $object->id;
      
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);
                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('mata_keywords_' . $lang->id);
                $objectLanguage->meta_description = $request->get('mata_description_' . $lang->id);

                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
            return ['status'=>false];
        }
    }

    function anyDelete($id) {
        $object = SuccessStories::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['success_story'] = $success_story = SuccessStories::findOrFail($id);
        $data['result'] = SuccessStoriesLanguages::where('success_story_id', $id)->where('language_id', '!=', $success_story->language->language_id)->get();
        return view('backend.success_stories.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['success_story'] = $success_story = SuccessStories::findOrFail($id);
        $ids = SuccessStoriesLanguages::where('success_story_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new SuccessStoriesLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/success_stories');
            }
        }
        return view('backend.success_stories.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['success_storyLanguage'] = $success_storyLanguage = SuccessStoriesLanguages::findOrFail($id);
        $ids = SuccessStoriesLanguages::where('success_story_id', $success_storyLanguage->success_story_id)
                        ->where('language_id', '!=', $success_storyLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($success_storyLanguage->success_story_id, $request, $success_storyLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/success_stories/languages/' . $success_storyLanguage->success_story_id);
            }
        }
        return view('backend.success_stories.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->success_story_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = SuccessStoriesLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }
    private function uploadfile($file) {
        $path = 'uploads/services';
        if (!file_exists($path)) {
            mkdir($path, 0775);
        }
        $datepath = date('m-Y', strtotime(\Carbon\Carbon::now()));
        if (!file_exists($path . '/' . $datepath)) {
            mkdir($path . '/' . $datepath, 0775);
        }
        $newdir = $path . '/' . $datepath;
        $exten = $file->getClientOriginalExtension();
        $name=explode('.',$file->getClientOriginalName());
        $filename = $name[0].time();
        $filename = $filename . '.' . $exten;
        $file->move($newdir, $filename);
        return $newdir . '/' . $filename;
    }

    private function generateRandom($length = 11) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = time();
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        return $randomString;
    }
}
