<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Statistics;
use App\Models\StatisticsLanguages;

class StatisticsController extends Controller {

    function anyIndex() {
        $data['result'] = Statistics::orderBy('id', 'desc')->get();
        return view('backend.statistics.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        if ($request->has('save')) {

            $return = $this->store($request, new Statistics());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/statistics');
            }
        }
        return view('backend.statistics.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['statistic'] = $statistic = Statistics::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();


        if ($request->has('save')) {
            $return = $this->store($request, $statistic);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/statistics');
            }
        }

        return view('backend.statistics.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\StatisticsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->statistic_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Statistics::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['statistic'] = $statistic = Statistics::findOrFail($id);
        $data['result'] = StatisticsLanguages::where('statistic_id', $id)->where('language_id', '!=', $statistic->language->language_id)->get();
        return view('backend.statistics.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['statistic'] = $statistic = Statistics::findOrFail($id);
        $ids = StatisticsLanguages::where('statistic_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new StatisticsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/statistics');
            }
        }
        return view('backend.statistics.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['statisticLanguage'] = $statisticLanguage = StatisticsLanguages::findOrFail($id);
        $ids = StatisticsLanguages::where('statistic_id', $statisticLanguage->statistic_id)
                        ->where('language_id', '!=', $statisticLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($statisticLanguage->statistic_id, $request, $statisticLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/statistics/languages/' . $statisticLanguage->statistic_id);
            }
        }
        return view('backend.statistics.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->statistic_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = StatisticsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
