<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\StaticPages;
use App\Models\StaticPagesLanguages;

class StaticPagesController extends Controller {

    function anyIndex() {
        $data['result'] = StaticPages::orderBy('id', 'desc')->get();
        return view('backend.staticpages.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::all();
        if ($request->has('save')) {

            $return = $this->store($request, new StaticPages(), new StaticPagesLanguages());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/staticpages/create-language/' . $return['id']);
            }
        }
        return view('backend.staticpages.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['staticpage'] = $staticpage = StaticPages::findOrFail($id);

        $ids = StaticPagesLanguages::where('static_page_id', $id)
                        ->where('language_id', '!=', $staticpage->language->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        $data['staticpageLanguage'] = $staticpageLanguage = $staticpage->language;
        if ($request->has('save')) {
            $return = $this->store($request, $staticpage, $staticpageLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                 return redirect('backend/staticpages');
            }
        }

        return view('backend.staticpages.update', $data);
    }

    function store($request, $object, $objectLanguage) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
          
            $object->image_id = $request->images['0'];
            $rules=[];
        
            if(!$object->exists){
            $object->slug = $request->slug;
         $rules = [
                'slug' => 'required|unique:static_pages,slug',
                
            ];
                     }


            $validator = \Validator::make($request->all(), $rules);
            if ($validator->fails()) {
                   \Session::flash('validate_errors', $validator->errors());
                throw new \Exception('validate exception');
            }
            



        
            $object->save();
        
            /**
             * Object language
             */
            $objectLanguage->language_id = $request->language_id;
            $objectLanguage->static_page_id = $object->id;
            $objectLanguage->title = $request->name;
            $objectLanguage->description = $request->description;

            if (!$objectLanguage->validate()) {
                \Session::flash('validate_errors', $objectLanguage->errors());
                throw new \Exception('validate exception');
            }
            $objectLanguage->save();
            \DB::commit();
            return ['status' => true, 'id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = StaticPages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['staticpage'] = $staticpage = StaticPages::findOrFail($id);
        $data['result'] = StaticPagesLanguages::where('static_page_id', $id)->where('language_id', '!=', $staticpage->language->language_id)->get();
        return view('backend.staticpages.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['staticpage'] = $staticpage = StaticPages::findOrFail($id);
        $ids = StaticPagesLanguages::where('static_page_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new StaticPagesLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                 return redirect('backend/staticpages');
            }
        }
        return view('backend.staticpages.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['staticpageLanguage'] = $staticpageLanguage = StaticPagesLanguages::findOrFail($id);
        $ids = StaticPagesLanguages::where('static_page_id', $staticpageLanguage->static_page_id)
                        ->where('language_id', '!=', $staticpageLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($staticpageLanguage->static_page_id, $request, $staticpageLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                  return redirect('backend/staticpages/languages/' . $staticpageLanguage->static_page_id);
            }
        }
        return view('backend.staticpages.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->static_page_id = $id;
        $objectLanguage->title = $request->name;
        $objectLanguage->description = $request->description;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = StaticPagesLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
