<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\CmsSetting;

/**
 * Description of AuthController
 *
 * @author Ahmed Sadany
 */
class SettingsController extends Controller {

    function index(Request $request) {
        $data['settings'] = new CmsSetting();
        if($request->has('ids')){
            $id= explode(',', $request->get('ids'));
           $data['settings']=$data['settings']->whereIn('id',$id); 
        }
        $data['settings']=$data['settings']->get();
        return view('cms-setting.settings.index', $data);
    }

    function create(Request $request, $id) {
        $data['type'] = $id;
        if ($request->has('key')) {
            $rules = [
                'key' => 'required|unique:cms_settings',
               
            ];
            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                \Session::put('errors', "This Key is exeist ");

                return redirect()->back();
            }
            $setting = new CmsSetting();
            $setting->key = $request->get('key');
            $setting->type = $id;
            if ($id == 1) {
                $setting->value = $request->get('value')[0];
            } else {
                $setting->value = $request->get('value');
            }
            $setting->save();
            \Session::put('success', "Successfully Added");
            return redirect(config('cms-settings.prefix') . '/settings');
        }

        return view('cms-setting.settings.create', $data);
    }

    function update(Request $request, $id) {
        $data['setting'] = $setting = CmsSetting::find($id);
        if (!is_object($setting)) {
            abort(404);
        }
        if ($request->has('value')) {
            $rules = [
                
            ];
            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                \Session::put('errors', "Please Fill all Fields");

                return redirect()->back();
            }
            if ($setting->type == 1) {
                $setting->value = $request->get('value')[0];
            } else {
                $setting->value = $request->get('value');
            }
            $setting->save();
            \Session::put('success', "Successfully Edited");
            return redirect(config('cms-settings.prefix') . '/settings');
        }
        return view('cms-setting.settings.update', $data);
    }
    function delete($id){
           $setting = CmsSetting::find($id);
        if (!is_object($setting)) {
            abort(404);
        }
        $setting->delete();
        \Session::put('success', "Successfully Deleted");
         return redirect(config('cms-settings.prefix') . '/settings');
    }
    public static function getAllSettings(){
        $settings= CmsSetting::all();
        foreach($settings as $setting){
             $_settings[$setting->key] = $setting->displayValue;
        }
        return $_settings;
    }

}
