<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\SecondaryCategories;
use App\Models\SecondaryCategoriesLanguages;

class SecondaryCategoriesController extends Controller {

    function anyIndex() {
        $data['result'] = SecondaryCategories::orderBy('id', 'desc')->get();
        return view('backend.secondary_categories.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        $data['categories']= \App\Models\MainCategories::all();

        if ($request->has('save')) {

            $return = $this->store($request, new SecondaryCategories());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/secondary_categories');
            }
        }
        return view('backend.secondary_categories.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['secondary_category'] = $secondary_category = SecondaryCategories::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        $data['categories']= \App\Models\MainCategories::all();


        if ($request->has('save')) {
            $return = $this->store($request, $secondary_category);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/secondary_categories');
            }
        }

        return view('backend.secondary_categories.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            $rules['category_id'] = 'required|exists:main_categories,id';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
              
                $rules['name_' . $lang->id] = 'required';
//                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
            $object->main_category_id = $request->category_id;


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\SecondaryCategoriesLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->secondary_category_id = $object->id;
                $objectLanguage->name = $request->get('name_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);
                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('mata_keywords_' . $lang->id);
                $objectLanguage->meta_description = $request->get('mata_description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = SecondaryCategories::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['secondary_category'] = $secondary_category = SecondaryCategories::findOrFail($id);
        $data['result'] = SecondaryCategoriesLanguages::where('secondary_category_id', $id)->where('language_id', '!=', $secondary_category->language->language_id)->get();
        return view('backend.secondary_categories.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['secondary_category'] = $secondary_category = SecondaryCategories::findOrFail($id);
        $ids = SecondaryCategoriesLanguages::where('secondary_category_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new SecondaryCategoriesLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/secondary_categories');
            }
        }
        return view('backend.secondary_categories.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['secondary_categoryLanguage'] = $secondary_categoryLanguage = SecondaryCategoriesLanguages::findOrFail($id);
        $ids = SecondaryCategoriesLanguages::where('secondary_category_id', $secondary_categoryLanguage->secondary_category_id)
                        ->where('language_id', '!=', $secondary_categoryLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($secondary_categoryLanguage->secondary_category_id, $request, $secondary_categoryLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/secondary_categories/languages/' . $secondary_categoryLanguage->secondary_category_id);
            }
        }
        return view('backend.secondary_categories.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->secondary_category_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = SecondaryCategoriesLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
