<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Products;
use App\Models\ProductsLanguages;

class ProductsController extends Controller {

    function anyIndex() {
        $data['result'] = Products::orderBy('id', 'desc')->get();
        return view('backend.products.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        $data['categories']= \App\Models\MainCategories::all();

        if ($request->has('save')) {

            $return = $this->store($request, new Products());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/products');
            }
        }
        return view('backend.products.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['product'] = $product = Products::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        $data['categories']= \App\Models\MainCategories::all();


        if ($request->has('save')) {
            $return = $this->store($request, $product);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/products');
            }
        }

        return view('backend.products.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            $rules['category_id'] = 'required|exists:secondary_categories,id';
    
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
              
                $rules['name_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
//                $rules['assortment_' . $lang->id] = 'required';
//                $rules['packaging_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
            $object->price = $request->price;
            $object->category_id = $request->category_id;
            if($request->is_file_deleted==1)
                $object->discover_file='';
            if($request->hasFile('discover_file'))
                $object->discover_file=$this->uploadfile($request->file('discover_file'));
            $object->in_home=$request->in_home;

            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\ProductsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->product_id = $object->id;
                $objectLanguage->name = $request->get('name_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);
                $objectLanguage->assortment = $request->get('assortment_' . $lang->id);
                $objectLanguage->packaging = $request->get('packaging_' . $lang->id);
                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('mata_keywords_' . $lang->id);
                $objectLanguage->meta_description = $request->get('mata_description_' . $lang->id);


                $objectLanguage->save();
            }
            $object->images()->delete();
            if($request->has('images')){
            foreach($request->images as $image){
                $new=new \App\Models\ProductsImages();
                $new->image_id=$image;
                $new->product_id=$object->id;
                $new->save();
            }}
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
  return ['status' => false];
        }
    }

    function anyDelete($id) {
        $object = Products::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['product'] = $product = Products::findOrFail($id);
        $data['result'] = ProductsLanguages::where('product_id', $id)->where('language_id', '!=', $product->language->language_id)->get();
        return view('backend.products.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['product'] = $product = Products::findOrFail($id);
        $ids = ProductsLanguages::where('product_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new ProductsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/products');
            }
        }
        return view('backend.products.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['productLanguage'] = $productLanguage = ProductsLanguages::findOrFail($id);
        $ids = ProductsLanguages::where('product_id', $productLanguage->product_id)
                        ->where('language_id', '!=', $productLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($productLanguage->product_id, $request, $productLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/products/languages/' . $productLanguage->product_id);
            }
        }
        return view('backend.products.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->product_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = ProductsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }
    private function uploadfile($file) {
        $path = 'uploads/services';
        if (!file_exists($path)) {
            mkdir($path, 0775);
        }
        $datepath = date('m-Y', strtotime(\Carbon\Carbon::now()));
        if (!file_exists($path . '/' . $datepath)) {
            mkdir($path . '/' . $datepath, 0775);
        }
        $newdir = $path . '/' . $datepath;
        $exten = $file->getClientOriginalExtension();
        $name=explode('.',$file->getClientOriginalName());
        $filename = $name[0].time();
        $filename = $filename . '.' . $exten;
        $file->move($newdir, $filename);
        return $newdir . '/' . $filename;
    }

    private function generateRandom($length = 11) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = time();
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        return $randomString;
    }
}
