<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\News;
use App\Models\NewsLanguages;

class NewsController extends Controller {

    function anyIndex() {
        $data['result'] = News::orderBy('id', 'desc')->get();
        return view('backend.news.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
//        dd($request->all());
        if ($request->has('save')) {

            $return = $this->store($request, new News());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/news');
            }
        }
        return view('backend.news.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['new'] = $new = News::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();



        if ($request->has('save')) {
            $return = $this->store($request, $new);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/news');
            }
        }

        return view('backend.news.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\NewsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->news_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->sub_description = $request->get('sub_description_' . $lang->id);
                                $objectLanguage->description = $request->get('description_' . $lang->id);

                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('meta_keyword_' . $lang->id);
                $objectLanguage->meta_description = $request->get('meta_description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
            return ['status' => false];
        }
    }

    function anyDelete($id) {
        $object = News::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['new'] = $new = News::findOrFail($id);
        $data['result'] = NewsLanguages::where('new_id', $id)->where('language_id', '!=', $new->language->language_id)->get();
        return view('backend.news.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['new'] = $new = News::findOrFail($id);
        $ids = NewsLanguages::where('new_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new NewsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/news');
            }
        }
        return view('backend.news.languages.create', $data);
    }

}
