<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\MenusLinks;
use App\Models\MenusLinksLanguages;

class MenusLinksController extends Controller {

    function order(Request $request) {
        if ($request->has('ids')) {
            foreach ($request->ids as $key => $id) {
                $menu = MenusLinks::find($id);
                $menu->order = $key;
                $menu->save();
            }
            \Session::flash('success', 'Ordered successfully.');
            return redirect('backend/menus_links/'.$menu->menu_id);
        }
    }

    function anyIndex($id) {
        $data['menu']=$menu = \App\Models\Menus::find($id);
        $data['result'] = MenusLinks::where('menu_id', $menu->id)->orderBy('order', 'asc')->get();
        return view('backend.menus_links.index', $data);
    }

    function anyCreate(Request $request, $id) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        $data['menu'] =$menu =  \App\Models\Menus::find($id);

        if ($request->has('save')) {
            $order = MenusLinks::where('menu_id', $menu->id)->max('order');
            $menulink = new MenusLinks();
            $menulink->order = $order+1;
            $menulink->menu_id=$menu->id;
            $return = $this->store($request, $menulink);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
              return redirect('backend/menus_links/'.$menu->id);
            }
        }
        return view('backend.menus_links.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['menu_link'] = $menu = MenusLinks::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
$data['menu'] = \App\Models\Menus::find($menu->menu_id);
        if ($request->has('save')) {
            $return = $this->store($request, $menu);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/menus_links/'.$menu->menu_id);
            }
        }

        return view('backend.menus_links.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            $rules['link'] = 'required';

            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->link = $request->link;


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\MenusLinksLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->menus_link_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = MenusLinks::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['menu'] = $menu = MenusLinks::findOrFail($id);
        $data['result'] = MenusLinksLanguages::where('menus_link_id', $id)->where('language_id', '!=', $menu->language->language_id)->get();
        return view('backend.menus_links.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['menu'] = $menu = MenusLinks::findOrFail($id);
        $ids = MenusLinksLanguages::where('menus_link_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new MenusLinksLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/menus_links');
            }
        }
        return view('backend.menus_links.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['menuLanguage'] = $menuLanguage = MenusLinksLanguages::findOrFail($id);
        $ids = MenusLinksLanguages::where('menus_link_id', $menuLanguage->menus_link_id)
                        ->where('language_id', '!=', $menuLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($menuLanguage->menus_link_id, $request, $menuLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/menus_links/languages/' . $menuLanguage->menus_link_id);
            }
        }
        return view('backend.menus_links.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->menus_link_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = MenusLinksLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
