<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Menus;
use App\Models\MenusLanguages;

class MenusController extends Controller {
    function order(Request $request){
        if($request->has('ids')){
            foreach ($request->ids as $key=>$id){
              $menu= Menus::find($id);
              $menu->order=$key;
              $menu->save();
            }
                \Session::flash('success', 'Ordered successfully.');
                return redirect('backend/menus');
        }
    }
            function anyIndex() {
        $data['result'] = Menus::orderBy('order', 'asc')->get();
        return view('backend.menus.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
     
        if ($request->has('save')) {
$order= Menus::max('order');
        $menu=new Menus();
$menu->order=$order+1;
            $return = $this->store($request, $menu);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/menus');
            }
        }
        return view('backend.menus.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['menu'] = $menu = Menus::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();

        if ($request->has('save')) {
            $return = $this->store($request, $menu);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/menus');
            }
        }

        return view('backend.menus.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            
            $rules['icon']='required';
             
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
              
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->link=$request->link;
            $object->icon=$request->icon;
         

            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\MenusLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->menu_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Menus::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['menu'] = $menu = Menus::findOrFail($id);
        $data['result'] = MenusLanguages::where('menu_id', $id)->where('language_id', '!=', $menu->language->language_id)->get();
        return view('backend.menus.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['menu'] = $menu = Menus::findOrFail($id);
        $ids = MenusLanguages::where('menu_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new MenusLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/menus');
            }
        }
        return view('backend.menus.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['menuLanguage'] = $menuLanguage = MenusLanguages::findOrFail($id);
        $ids = MenusLanguages::where('menu_id', $menuLanguage->menu_id)
                        ->where('language_id', '!=', $menuLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($menuLanguage->menu_id, $request, $menuLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/menus/languages/' . $menuLanguage->menu_id);
            }
        }
        return view('backend.menus.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->menu_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = MenusLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
