<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\MainCategories;
use App\Models\MainCategoriesLanguages;

class MainCategoriesController extends Controller {

    function anyIndex() {
        $data['result'] = MainCategories::orderBy('id', 'desc')->get();
        return view('backend.main_categories.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
//        dd($request->all());
        if ($request->has('save')) {

            $return = $this->store($request, new MainCategories());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/main_categories');
            }
        }
        return view('backend.main_categories.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['main_category'] = $main_category = MainCategories::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();



        if ($request->has('save')) {
            $return = $this->store($request, $main_category);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/main_categories');
            }
        }

        return view('backend.main_categories.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
              
                $rules['name_' . $lang->id] = 'required';
//                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
            $object->in_home = $request->in_home;


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\MainCategoriesLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->main_category_id = $object->id;
                $objectLanguage->name = $request->get('name_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);
                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('mata_keywords_' . $lang->id);
                $objectLanguage->meta_description = $request->get('mata_description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = MainCategories::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['main_category'] = $main_category = MainCategories::findOrFail($id);
        $data['result'] = MainCategoriesLanguages::where('main_category_id', $id)->where('language_id', '!=', $main_category->language->language_id)->get();
        return view('backend.main_categories.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['main_category'] = $main_category = MainCategories::findOrFail($id);
        $ids = MainCategoriesLanguages::where('main_category_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new MainCategoriesLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/main_categories');
            }
        }
        return view('backend.main_categories.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['main_categoryLanguage'] = $main_categoryLanguage = MainCategoriesLanguages::findOrFail($id);
        $ids = MainCategoriesLanguages::where('main_category_id', $main_categoryLanguage->main_category_id)
                        ->where('language_id', '!=', $main_categoryLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($main_categoryLanguage->main_category_id, $request, $main_categoryLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/main_categories/languages/' . $main_categoryLanguage->main_category_id);
            }
        }
        return view('backend.main_categories.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->main_category_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = MainCategoriesLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
