<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\IndexSections;
use App\Models\IndexSectionsLanguages;

class IndexSectionsController extends Controller {

    function anyIndex() {
        $data['result'] = IndexSections::orderBy('id', 'desc')->get();
        return view('backend.index_sections.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
//        dd($request->all());
        if ($request->has('save')) {

            $return = $this->store($request, new IndexSections());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/index_sections');
            }
        }
        return view('backend.index_sections.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['index_section'] = $index_section = IndexSections::findOrFail($id);
       
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();



        if ($request->has('save')) {
            $return = $this->store($request, $index_section);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/index_sections');
            }
        }

        return view('backend.index_sections.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            // $rules['image'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
                $rules['name_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            if($request->image!='')
            $object->image_id = $request->image;
            $object->link = $request->link;
    

            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\IndexSectionsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->index_section_id = $object->id;
                $objectLanguage->name = $request->get('name_' . $lang->id);
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);
                $objectLanguage->sub_title = $request->get('sub_title_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
return ['status'=>false];
        }
    }

    function anyDelete($id) {
        $object = IndexSections::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['index_section'] = $index_section = IndexSections::findOrFail($id);
        $data['result'] = IndexSectionsLanguages::where('index_section_id', $id)->where('language_id', '!=', $index_section->language->language_id)->get();
        return view('backend.index_sections.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['index_section'] = $index_section = IndexSections::findOrFail($id);
        $ids = IndexSectionsLanguages::where('index_section_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new IndexSectionsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/index_sections');
            }
        }
        return view('backend.index_sections.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['index_sectionLanguage'] = $index_sectionLanguage = IndexSectionsLanguages::findOrFail($id);
        $ids = IndexSectionsLanguages::where('index_section_id', $index_sectionLanguage->index_section_id)
                        ->where('language_id', '!=', $index_sectionLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($index_sectionLanguage->index_section_id, $request, $index_sectionLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/index_sections/languages/' . $index_sectionLanguage->index_section_id);
            }
        }
        return view('backend.index_sections.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->index_section_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = IndexSectionsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
