<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Galleries;
use App\Models\GalleriesLanguages;

class GalleriesController extends Controller {

    function anyIndex() {
        $data['result'] = Galleries::orderBy('id', 'desc')->get();
        return view('backend.galleries.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        $data['categories']= \App\Models\MainCategories::all();

        if ($request->has('save')) {

            $return = $this->store($request, new Galleries());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/galleries');
            }
        }
        return view('backend.galleries.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['gallery'] = $gallery = Galleries::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        $data['categories']= \App\Models\MainCategories::all();


        if ($request->has('save')) {
            $return = $this->store($request, $gallery);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/galleries');
            }
        }

        return view('backend.galleries.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
          
            $rules['images'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
              
                $rules['name_' . $lang->id] = 'required';

            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
          


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\GalleriesLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->gallery_id = $object->id;
                $objectLanguage->name = $request->get('name_' . $lang->id);
                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('mata_keywords_' . $lang->id);
                $objectLanguage->meta_description = $request->get('mata_description_' . $lang->id);


                $objectLanguage->save();
            }
            $object->images()->delete();
            foreach($request->images as $image){
                $new=new \App\Models\GalleryImages();
                $new->image_id=$image;
                $new->gallery_id=$object->id;
                $new->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Galleries::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['gallery'] = $gallery = Galleries::findOrFail($id);
        $data['result'] = GalleriesLanguages::where('gallery_id', $id)->where('language_id', '!=', $gallery->language->language_id)->get();
        return view('backend.galleries.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['gallery'] = $gallery = Galleries::findOrFail($id);
        $ids = GalleriesLanguages::where('gallery_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new GalleriesLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/galleries');
            }
        }
        return view('backend.galleries.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['galleryLanguage'] = $galleryLanguage = GalleriesLanguages::findOrFail($id);
        $ids = GalleriesLanguages::where('gallery_id', $galleryLanguage->gallery_id)
                        ->where('language_id', '!=', $galleryLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($galleryLanguage->gallery_id, $request, $galleryLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/galleries/languages/' . $galleryLanguage->gallery_id);
            }
        }
        return view('backend.galleries.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->gallery_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = GalleriesLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
