<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Features;
use App\Models\FeaturesLanguages;

class FeaturesController extends Controller {

    function anyIndex() {
        $data['result'] = Features::orderBy('id', 'desc')->get();
        return view('backend.features.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        if ($request->has('save')) {

            $return = $this->store($request, new Features());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/features');
            }
        }
        return view('backend.features.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['feature'] = $feature = Features::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();

        if ($request->has('save')) {
            $return = $this->store($request, $feature);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/features');
            }
        }

        return view('backend.features.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
              
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;


            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\FeaturesLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->feature_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Features::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['feature'] = $feature = Features::findOrFail($id);
        $data['result'] = FeaturesLanguages::where('feature_id', $id)->where('language_id', '!=', $feature->language->language_id)->get();
        return view('backend.features.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['feature'] = $feature = Features::findOrFail($id);
        $ids = FeaturesLanguages::where('feature_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new FeaturesLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/features');
            }
        }
        return view('backend.features.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['featureLanguage'] = $featureLanguage = FeaturesLanguages::findOrFail($id);
        $ids = FeaturesLanguages::where('feature_id', $featureLanguage->feature_id)
                        ->where('language_id', '!=', $featureLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($featureLanguage->feature_id, $request, $featureLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/features/languages/' . $featureLanguage->feature_id);
            }
        }
        return view('backend.features.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->feature_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = FeaturesLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
