<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Events;
use App\Models\EventsLanguages;

class EventsController extends Controller {

    function anyIndex() {
        $data['result'] = Events::orderBy('id', 'desc')->get();
        return view('backend.events.index', $data);
    }
    function addToIndex($id){
        $event= Events::findOrFail($id);
        if($event->in_index==1){
        $event->in_index=0;
        } else{
            $event->in_index=1;
        }
        $event->save();
        \Session::flash('success', 'Update successfully.');
        return redirect()->back();
    }
            function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
//        dd($request->all());
        if ($request->has('save')) {

            $return = $this->store($request, new Events());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/events');
            }
        }
        return view('backend.events.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['event'] = $event = Events::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();



        if ($request->has('save')) {
            $return = $this->store($request, $event);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/events');
            }
        }

        return view('backend.events.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            $rules['start_time'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
               
                $rules['address_' . $lang->id] = 'required';
                $rules['name_' . $lang->id] = 'required';
                $rules['sub_description_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
            $object->map_link = $request->map_link;
            $object->start_time=date('Y-m-d H:i:s',strtotime($request->start_time));
            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\EventsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->event_id = $object->id;
                $objectLanguage->name = $request->get('name_' . $lang->id);
                $objectLanguage->address = $request->get('address_' . $lang->id);
                $objectLanguage->sub_description = $request->get('sub_description_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);
                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('meta_keyword_' . $lang->id);
                $objectLanguage->meta_description = $request->get('meta_description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
              return ['status' => false];
        }
    }

    function anyDelete($id) {
        $object = Events::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }


}
