<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Departments;

class DepartmentsController extends Controller {

    function anyIndex(Request $request) {

        $data['result'] = Departments::orderBy('id', 'desc');
      
        $data['result'] = $data['result']->paginate(15);
        return view('backend.departments.index', $data);
    }

    function anyCreate(Request $request) {

        if ($request->has('save')) {

            $return = $this->store($request, new Departments());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/departments');
            }
        }
        return view('backend.departments.create');
    }

    function anyEdit(Request $request, $id) {
        $data['department'] = $department = Departments::findOrFail($id);
        if ($request->has('save')) {
            $return = $this->store($request, $department);

            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/departments');
            }
        }

        return view('backend.departments.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules = [
                'name_en' => 'required',
                'name_ar' => 'required',
              
            ];
            $validator = \Validator::make($request->all(), $rules);

                if ($validator->fails()) {
                    \Session::flash('validate_errors', $validator->errors()->all());
                    throw new \Exception('validate exception');
                }

            $object->name_en = $request->name_en;
            $object->name_ar = $request->name_ar;
           

            $object->save();


            \DB::commit();
            return ['status' => true, 'object' => $object];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function active($id) {
        $object = Departments::findOrFail($id);
        if ($object->active == 1) {
            $object->active = 0;
        } else {
            $object->active = 1;
        }
        $object->save();
        \Session::flash('success', 'Update successfully.');
        return redirect('backend/departments');
    }

    function updatePass(Request $request, $id) {
        $object = Departments::findOrFail($id);
        if ($request->has('password')) {
            $rules = [
                'password' => 'required',
                'confirm_password' => 'required|same:password'
            ];
            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {
                \Session::flash('validate_errors', $validator->errors()->all());

                return redirect()->back();
            }
            $object->password = md5($request->password);
            $object->save();
            \Session::flash('success', 'Update successfully.');
            return redirect('backend/departments');
        }
        return view('backend.departments.updatePass');
    }

    function anyDelete($id) {
        $object = Departments::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
