<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Collaborators;
use App\Models\Partners;

class DashboardController extends Controller {

    function anyIndex() {
        $data['services']= \App\Models\Services::count();
        $data['news']= \App\Models\News::count();
        $data['events']= \App\Models\Events::count();
        $data['partners']=Partners::count();
        $data['collaborators']=Collaborators::count();
       
        $data['cvs']= \App\Models\Career::count();

        $data['subscribers']= \App\Models\Subscribers::count();
        return view('backend.dashboard',$data);
    }

    function hidden($id) {
        $image = \Elsayednofal\Imagemanager\Models\ImageManagerModel::find($id);
        $image->hidden = 1;
        $image->save();
        return ['status' => true, 'id' => $id];
    }

    function analytics() {
        return view('backend.test');
    }

    function replace() {
        $data = \App\Models\StaticPagesLanguages::all();
        foreach ($data as $page) {
            $page->description = str_replace('http://http://', 'http://', $page->description);

            $page->save();
        }
    }

    function testCalender() {
        $time = \Carbon\Carbon::now();
        $month = date('m', strtotime($time));
        $year = date('y', strtotime($time));
        $data['calender'] = $this->draw_calendar($month, $year);
        return view('backend.calender', $data);
    }

    function draw_calendar($month, $year) {

        /* draw table */
        $calendar = '<table cellpadding="0" cellspacing="0" class="calendar">';

        /* table headings */
        $headings = array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday');
        $calendar .= '<tr class="calendar-row"><td class="calendar-day-head">' . implode('</td><td class="calendar-day-head">', $headings) . '</td></tr>';

        /* days and weeks vars now ... */
        $running_day = date('w', mktime(0, 0, 0, $month, 1, $year));
        $days_in_month = date('t', mktime(0, 0, 0, $month, 1, $year));
        $days_in_this_week = 1;
        $day_counter = 0;
        $dates_array = array();

        /* row for week one */
        $calendar .= '<tr class="calendar-row">';

        /* print "blank" days until the first of the current week */
        for ($x = 0; $x < $running_day; $x++):
            $calendar .= '<td class="calendar-day-np"> </td>';
            $days_in_this_week++;
        endfor;

        /* keep going with days.... */
        for ($list_day = 1; $list_day <= $days_in_month; $list_day++):
            $calendar .= '<td class="calendar-day">';
            /* add in the day number */
            $calendar .= '<div class="day-number">' . $list_day . '</div>';

            /** QUERY THE DATABASE FOR AN ENTRY FOR THIS DAY !!  IF MATCHES FOUND, PRINT THEM !! * */
            $calendar .= str_repeat('<p> </p>', 2);

            $calendar .= '</td>';
            if ($running_day == 6):
                $calendar .= '</tr>';
                if (($day_counter + 1) != $days_in_month):
                    $calendar .= '<tr class="calendar-row">';
                endif;
                $running_day = -1;
                $days_in_this_week = 0;
            endif;
            $days_in_this_week++;
            $running_day++;
            $day_counter++;
        endfor;

        /* finish the rest of the days in the week */
        if ($days_in_this_week < 8):
            for ($x = 1; $x <= (8 - $days_in_this_week); $x++):
                $calendar .= '<td class="calendar-day-np"> </td>';
            endfor;
        endif;

        /* final row */
        $calendar .= '</tr>';

        /* end the table */
        $calendar .= '</table>';

        /* all done, return result */
        return $calendar;
    }

    /* sample usages */
}
