<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\CompanyEvents;
use App\Models\CompanyEventsLanguages;

class CompanyEventsController extends Controller {

    function anyIndex() {
        $data['result'] = CompanyEvents::orderBy('id', 'desc')->get();
        return view('backend.company_events.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        if ($request->has('save')) {

            $return = $this->store($request, new CompanyEvents());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/company_events');
            }
        }
        return view('backend.company_events.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['company_event'] = $company_event = CompanyEvents::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();


        if ($request->has('save')) {
            $return = $this->store($request, $company_event);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/company_events');
            }
        }

        return view('backend.company_events.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
            $rules['date'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
            $object->date=$request->date;

            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\CompanyEventsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->company_event_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = CompanyEvents::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['company_event'] = $company_event = CompanyEvents::findOrFail($id);
        $data['result'] = CompanyEventsLanguages::where('company_event_id', $id)->where('language_id', '!=', $company_event->language->language_id)->get();
        return view('backend.company_events.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['company_event'] = $company_event = CompanyEvents::findOrFail($id);
        $ids = CompanyEventsLanguages::where('company_event_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new CompanyEventsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/company_events');
            }
        }
        return view('backend.company_events.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['company_eventLanguage'] = $company_eventLanguage = CompanyEventsLanguages::findOrFail($id);
        $ids = CompanyEventsLanguages::where('company_event_id', $company_eventLanguage->company_event_id)
                        ->where('language_id', '!=', $company_eventLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($company_eventLanguage->company_event_id, $request, $company_eventLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/company_events/languages/' . $company_eventLanguage->company_event_id);
            }
        }
        return view('backend.company_events.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->company_event_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = CompanyEventsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
