<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Collaborators;


class CollaboratorsController extends Controller {

    function anyIndex() {
        $data['result'] = Collaborators::orderBy('id', 'desc')->get();
        return view('backend.collaborators.index', $data);
    }

    function anyCreate(Request $request) {
       
        if ($request->has('save')) {

            $return = $this->store($request, new Collaborators());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/collaborators');
            }
        }
        return view('backend.collaborators.create');
    }

    function anyEdit(Request $request, $id) {
        $data['partner'] = $partner = Collaborators::findOrFail($id);



        if ($request->has('save')) {
            $return = $this->store($request, $partner);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/collaborators');
            }
        }

        return view('backend.collaborators.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';


            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
            $object->link=$request->link;

            $object->save();

            /**
             * Object language
             */
          
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
            return ['status' => false];
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Collaborators::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['partner'] = $partner = Collaborators::findOrFail($id);
        $data['result'] = CollaboratorsLanguages::where('partner_id', $id)->where('language_id', '!=', $partner->language->language_id)->get();
        return view('backend.partners.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['partner'] = $partner = Collaborators::findOrFail($id);
        $ids = CollaboratorsLanguages::where('partner_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new CollaboratorsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/partners');
            }
        }
        return view('backend.partners.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['partnerLanguage'] = $partnerLanguage = PartnersLanguages::findOrFail($id);
        $ids = PartnersLanguages::where('partner_id', $partnerLanguage->partner_id)
                        ->where('language_id', '!=', $partnerLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($partnerLanguage->partner_id, $request, $partnerLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/partners/languages/' . $partnerLanguage->partner_id);
            }
        }
        return view('backend.partners.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->partner_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = PartnersLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
