<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Certifications;
use App\Models\CertificationsLanguages;

class CertificationsController extends Controller {

    function anyIndex() {
        $data['result'] = Certifications::orderBy('id', 'desc')->get();
        return view('backend.certifications.index', $data);
    }
  function addToIndex($id){
        $event= Certifications::findOrFail($id);
        if($event->in_index==1){
        $event->in_index=0;
        } else{
            $event->in_index=1;
        }
        $event->save();
        \Session::flash('success', 'Update successfully.');
        return redirect()->back();
    }
    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
//        dd($request->all());
        if ($request->has('save')) {

            $return = $this->store($request, new Certifications());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/certifications');
            }
        }
        return view('backend.certifications.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['certification'] = $certification = Certifications::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();



        if ($request->has('save')) {
            $return = $this->store($request, $certification);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/certifications');
            }
        }

        return view('backend.certifications.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            
            /**
             * Object
             */
            $rules['image'] = 'required';
            $rules['image_id'] = 'required';
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';
                $rules['sub_description_' . $lang->id] = 'required';
                $rules['description_' . $lang->id] = 'required';
            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->logo_id = $request->image;
            $object->image_id = $request->image_id;


            $object->save();
           
            if($request->has('decauments')){
                $object->files()->delete();
            foreach($request->decauments as $key=>$file){
                $one=new \App\Models\CertificationsFiles();
                $one->certification_id=$object->id;
                $one->file= $this->uploadfile($file);
                $one->save();
            }
            }
            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\CertificationsLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->certification_id = $object->id;
               
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->sub_description = $request->get('sub_description_' . $lang->id);
                $objectLanguage->description = $request->get('description_' . $lang->id);
                $objectLanguage->meta_title = $request->get('meta_title_' . $lang->id);
                $objectLanguage->meta_keywords = $request->get('meta_keyword_' . $lang->id);
                $objectLanguage->meta_description = $request->get('meta_description_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Certifications::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['certification'] = $certification = Certifications::findOrFail($id);
        $data['result'] = CertificationsLanguages::where('certification_id', $id)->where('language_id', '!=', $certification->language->language_id)->get();
        return view('backend.certifications.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['certification'] = $certification = Certifications::findOrFail($id);
        $ids = CertificationsLanguages::where('certification_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new CertificationsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/certifications');
            }
        }
        return view('backend.certifications.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['certificationLanguage'] = $certificationLanguage = CertificationsLanguages::findOrFail($id);
        $ids = CertificationsLanguages::where('certification_id', $certificationLanguage->certification_id)
                        ->where('language_id', '!=', $certificationLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($certificationLanguage->certification_id, $request, $certificationLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/certifications/languages/' . $certificationLanguage->certification_id);
            }
        }
        return view('backend.certifications.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->certification_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = CertificationsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }
 private function uploadfile($file) {
        $path = 'uploads/files';
        if (!file_exists($path)) {
            mkdir($path, 0775);
        }
        $datepath = date('m-Y', strtotime(\Carbon\Carbon::now()));
        if (!file_exists($path . '/' . $datepath)) {
            mkdir($path . '/' . $datepath, 0775);
        }
        $newdir = $path . '/' . $datepath;
        $exten = $file->getClientOriginalExtension();
        $filename = $this->generateRandom($length = 15);
        $filename = $filename . '.' . $exten;
        $file->move($newdir, $filename);
        return $newdir . '/' . $filename;
    }
     function generateRandom($length = 11) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = time();
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }

        return $randomString;
    }
}
