<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Categories;
use App\Models\CategoriesLanguages;

class CategoriesController extends Controller {

    function anyIndex() {
        $data['result'] = Categories::orderBy('id', 'desc')->get();
        return view('backend.categories.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        if ($request->has('save')) {

            $return = $this->store($request, new Categories());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/categories');
            }
        }
        return view('backend.categories.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['goal'] = $goal = Categories::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();


        if ($request->has('save')) {
            $return = $this->store($request, $goal);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/categories');
            }
        }

        return view('backend.categories.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
            /**
             * Object
             */
            $rules['image'] = 'required';
           
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $rules['title_' . $lang->id] = 'required';

            }

            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;
            $object->parent_id=$request->parent_id;
        

            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\CategoriesLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->category_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Categories::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['goal'] = $goal = Goals::findOrFail($id);
        $data['result'] = GoalsLanguages::where('goal_id', $id)->where('language_id', '!=', $goal->language->language_id)->get();
        return view('backend.goals.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['goal'] = $goal = Goals::findOrFail($id);
        $ids = GoalsLanguages::where('goal_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new GoalsLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/goals');
            }
        }
        return view('backend.goals.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['goalLanguage'] = $goalLanguage = GoalsLanguages::findOrFail($id);
        $ids = GoalsLanguages::where('goal_id', $goalLanguage->goal_id)
                        ->where('language_id', '!=', $goalLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($goalLanguage->goal_id, $request, $goalLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/goals/languages/' . $goalLanguage->goal_id);
            }
        }
        return view('backend.goals.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->goal_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = GoalsLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
