<?php
namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Career;
use App\Models\Goals;
use App\Models\GoalsLanguages;

class CareersController extends Controller {
    function index(){
        $data['result']= \App\Models\Career::orderBy('id','desc')->paginate(20);
        return view('backend.careers.index',$data);
    }
   
  
    function download(){
        return \Maatwebsite\Excel\Facades\Excel::download(new export\ExportCareer, 'careers.xlsx');     
    }
    function downloadcontact(){
        return \Maatwebsite\Excel\Facades\Excel::download(new export\ExportContacts(), 'contacts.xlsx');  
    }
    function anyDelete($id) {
        $object = Career::findOrFail($id);

       if (is_object($object)) {
           $object->delete();
           $response = new \stdClass();
           $response->status = 'Ok';
           $response->message = 'Deleted successfully';
       } else {
           $response = new \stdClass();
           $response->status = 'Warning';
           $response->message = 'Row can not be deleted';
       }
       echo json_encode($response);
   }
    
}