<?php

namespace App\Http\Controllers\Backend;

use Illuminate\Http\Request;
use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Models\Banners;
use App\Models\BannersLanguages;

class BannersController extends Controller {

    function anyIndex() {
        $data['result'] = Banners::orderBy('id', 'desc')->get();
        return view('backend.banners.index', $data);
    }

    function anyCreate(Request $request) {
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();
        if ($request->has('save')) {

            $return = $this->store($request, new Banners());
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/banners');
            }
        }
        return view('backend.banners.create', $data);
    }

    function anyEdit(Request $request, $id) {
        $data['banner'] = $banner = Banners::findOrFail($id);
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->get();


        if ($request->has('save')) {
            $return = $this->store($request, $banner);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Update successfully.');
                return redirect('backend/banners');
            }
        }

        return view('backend.banners.update', $data);
    }

    function store($request, $object) {
        \DB::beginTransaction();
        try {
         
            /**
             * Object
             */
            $rules['image'] = 'required';
          
            $validator = \Validator::make($request->all(), $rules);

            if ($validator->fails()) {

                session()->flash('validate_errors', $validator->errors()->all());
                throw new \Exception('validate exception');
            }
            $object->image_id = $request->image;

            $object->blue_link=$request->blue_link;
            $object->white_link=$request->white_link;
            $object->save();

            /**
             * Object language
             */
            foreach (\App\Models\Languages::where('is_active', 1)->get() as $lang) {
                $objectLanguage = $object->langs()->where('language_id', $lang->id)->first();
                if (!is_object($objectLanguage))
                    $objectLanguage = new \App\Models\BannersLanguages();
                $objectLanguage->language_id = $lang->id;

                $objectLanguage->banner_id = $object->id;
                $objectLanguage->title = $request->get('title_' . $lang->id);
                $objectLanguage->sub_title = $request->get('sub_title_' . $lang->id);
                $objectLanguage->blue_text = $request->get('blue_text_' . $lang->id);
                $objectLanguage->white_text = $request->get('white_text_' . $lang->id);


                $objectLanguage->save();
            }
            \DB::commit();
            return ['status' => true, 'object_id' => $object->id];
        } catch (\Exception $exception) {
            \DB::rollBack();
//            dd($exception);
        }
    }

    function anyDelete($id) {
        $object = Banners::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

    function anyLanguages($id) {
        $data['banner'] = $banner = Banners::findOrFail($id);
        $data['result'] = BannersLanguages::where('banner_id', $id)->where('language_id', '!=', $banner->language->language_id)->get();
        return view('backend.banners.languages.index', $data);
    }

    function anyCreateLanguage(Request $request, $id) {
        $data['banner'] = $banner = Banners::findOrFail($id);
        $ids = BannersLanguages::where('banner_id', $id)
                        ->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {

            $return = $this->storeLanguage($id, $request, new BannersLanguages);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Insert successfully.');
                return redirect('backend/banners');
            }
        }
        return view('backend.banners.languages.create', $data);
    }

    function anyEditLanguage(Request $request, $id) {
        $data['bannerLanguage'] = $bannerLanguage = BannersLanguages::findOrFail($id);
        $ids = BannersLanguages::where('banner_id', $bannerLanguage->banner_id)
                        ->where('language_id', '!=', $bannerLanguage->language_id)->pluck('language_id')->toArray();
        $data['languages'] = \App\Models\Languages::where('is_active', 1)->whereNotIn('id', $ids)->get();
        if ($request->has('save')) {
            $return = $this->storeLanguage($bannerLanguage->banner_id, $request, $bannerLanguage);
            if ($return['status'] == TRUE) {

                \Session::flash('success', 'Updated successfully.');
                return redirect('backend/banners/languages/' . $bannerLanguage->banner_id);
            }
        }
        return view('backend.banners.languages.update', $data);
    }

    function storeLanguage($id, $request, $objectLanguage) {
        $objectLanguage->language_id = $request->language_id;
        $objectLanguage->banner_id = $id;
        $objectLanguage->description = $request->description;
        $objectLanguage->title = $request->title;

        if (!$objectLanguage->validate()) {
            \Session::flash('validate_errors', $objectLanguage->errors());
            throw new \Exception('validate exception');
        }
        $objectLanguage->save();
        return ['status' => true];
    }

    function anyDeleteLanguage($id) {
        $object = BannersLanguages::findOrFail($id);

        if (is_object($object)) {
            $object->delete();
            $response = new \stdClass();
            $response->status = 'Ok';
            $response->message = 'Deleted successfully';
        } else {
            $response = new \stdClass();
            $response->status = 'Warning';
            $response->message = 'Row can not be deleted';
        }
        echo json_encode($response);
    }

}
